
require( "quest/m2_kitchencabinet/convout.lua" );
combine_speech_tables();

-- synch this with m2_kitchen.lua
local recipeInfo =
{
	ingredients = { "Milk", "Frozen Raspberries", "Flour", "Applesauce", "Sauerkraut", "Baking Powder", "Oyster Sauce", "Sugar", "6 Double Yolk Eggs", "Minty Mint Crisps" };
}

-- Uncomment image names to see debugging grid
local gridSquareCupboard = 
{
	width = 42,
	height = 42,
	depth = 3,
	alpha = 0.75,
	image = "gridSquare",
	highlight = "gridSquareHighlight",
	occupied = "gridSquare"
};

local gridSquareFridge = 
{
	width = 42,
	height = 42,
	depth = 3,
	alpha = 0.75,
	image = "gridSquare",
	highlight = "gridSquareHighlightFridge",
	occupied = "gridSquare"
};


local gridSquare = gridSquareCupboard;

local gridFormatInfo = 
{
	grid_width = 8,
	grid_height = 11,
	screen_x_offset = 230,
	screen_y_offset = 18
};

local floorFormatInfo = 
{
	floor_width = 330,
	floor_height = 600,
	screen_x_offset = 470,
	screen_y_offset = 0
}

local grid = { };
local package_items = { };
local shelves = { };

local skipChecks = false;

local gridSpawned = false;
numPackageItems = 0;
numShelves = 0;

local currentDepth = 0;

local foregroundDepth = 5;
local backgroundDepth = 1;
local targetDepth = 4;
local target_item = nil; -- used in activity_passed
local moving_actor = nil;

-- for the purposes of this activity, maxCollisionHeight and maxCollisionWidth should both be odd and should both be the same (may work if not same)
local collisionInfo = 
{	
	maxCollisionHeight = 5, 
	maxCollisionWidth = 5
};

-- NOTE: For this activity, the collision mask should not have "holes"

-- NOTE: Shelves must always specify a bottom shelf - 11 for this activity

local fridge_items = 
{
	fridge_butter =
	{
		image = "fridge_butter", xCollisionCheckOffset = 103, yCollisionCheckOffset = 19,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			1, 1, 1, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	fridge_mayo =
 	{
  		image = "fridge_mayo", xCollisionCheckOffset = 59, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0,
   		0, 0, 0, 0, 0
  		}
 	},
	fridge_milk =
	{
		image = "fridge_milk", xCollisionCheckOffset = 63, yCollisionCheckOffset = 60,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 1, 1, 1, 1,
			0, 1, 1, 1, 1,
			0, 1, 1, 1, 1,
			0, 1, 1, 1, 1
		}
	},
	fridge_oj =
 	{
  		image = "fridge_oj", xCollisionCheckOffset = 57, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0
  		}
 	},
	fridge_peanutbutter =
	{
		image = "fridge_peanutbutter", xCollisionCheckOffset = 59, yCollisionCheckOffset = 60,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 1, 1, 0, 0,
			0, 1, 1, 0, 0,
			0, 1, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	fridge_soda =
	{
		image = "fridge_soda", xCollisionCheckOffset = 20, yCollisionCheckOffset = 102, 
		collisionMask =
		{
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	fridge_spaghetti =
	{
		image = "fridge_spaghetti", xCollisionCheckOffset = 57, yCollisionCheckOffset = 61,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 1, 1, 0, 0,
			0, 1, 1, 0, 0,
			0, 1, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	fridge_water =
	{
		image = "fridge_water", xCollisionCheckOffset = 17, yCollisionCheckOffset = 19,
		collisionMask = 
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	fridge_wine =
	{
		image = "fridge_wine", xCollisionCheckOffset = 19, yCollisionCheckOffset = 101,
		collisionMask =
		{
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	fridge_yogurt =
	{
		image = "fridge_yogurt", xCollisionCheckOffset = 19, yCollisionCheckOffset = 18,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
	},

	freezer_berries =
	{
		image = "freezer_berries", xCollisionCheckOffset = 50, yCollisionCheckOffset = 50,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0, 1, 1, 1, 1,
			0, 1, 1, 1, 1,
			0, 1, 1, 1, 1
		}
	},
	freezer_bread =
 	{
  		image = "freezer_bread", xCollisionCheckOffset = 59, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0
  		}
 	},
	freezer_coffee =
	{
		image = "freezer_coffee", xCollisionCheckOffset = 57, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0
  		}
	},
	freezer_dinner =
 	{
  		image = "freezer_dinner", xCollisionCheckOffset = 20, yCollisionCheckOffset = 102, 
		collisionMask =
		{
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
 	},
	freezer_icecream =
	{
		image = "freezer_icecream", xCollisionCheckOffset = 62, yCollisionCheckOffset = 57,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	freezer_icetray =
	{
		image = "freezer_icetray", xCollisionCheckOffset = 60, yCollisionCheckOffset = 20, 
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0, 1, 1, 1, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	freezer_juice =
	{
		image = "freezer_juice", xCollisionCheckOffset = 17, yCollisionCheckOffset = 19,
		collisionMask = 
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	freezer_lemonade =
	{
		image = "freezer_lemonade", xCollisionCheckOffset = 17, yCollisionCheckOffset = 16,
		collisionMask = 
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 1, 1, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	freezer_pizza =
	{
		image = "freezer_pizza", xCollisionCheckOffset = 19, yCollisionCheckOffset = 101,
		collisionMask =
		{
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	freezer_whipcream =
	{
		image = "freezer_whipcream", xCollisionCheckOffset = 59, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0,
   		0, 0, 0, 0, 0
  		}
 	},
	cabinet_applesauce =
	{
		image = "cabinet_applesauce", xCollisionCheckOffset = 57, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0
  		}
 	},
	cabinet_bakingsoda =
	{
		image = "cabinet_bakingsoda", xCollisionCheckOffset = 59, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0,
   		0, 0, 0, 0, 0
  		}
 	},
	cabinet_cakemix =
	{
		image = "cabinet_cakemix", xCollisionCheckOffset = 59, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0
  		}
 	},
	cabinet_cereal =
	{
		image = "cabinet_cereal", xCollisionCheckOffset = 19, yCollisionCheckOffset = 101,
		collisionMask =
		{
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	cabinet_chips =
	{
		image = "cabinet_chips", xCollisionCheckOffset = 62, yCollisionCheckOffset = 60,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	cabinet_cocoa =
	{
		image = "cabinet_cocoa", xCollisionCheckOffset = 59, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0,
   		0, 0, 0, 0, 0
  		}
 	},
	cabinet_dinner =
	{
		image = "cabinet_dinner", xCollisionCheckOffset = 103, yCollisionCheckOffset = 22,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			1, 1, 1, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	cabinet_flour =
	{
		image = "cabinet_flour", xCollisionCheckOffset = 63, yCollisionCheckOffset = 60,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 1, 1, 1, 1,
			0, 1, 1, 1, 1,
			0, 1, 1, 1, 1,
			0, 1, 1, 1, 1
		}
	},
	cabinet_kraut =
	{
		image = "cabinet_kraut", xCollisionCheckOffset = 63, yCollisionCheckOffset = 60,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0
		}
	},
	cabinet_oat =
	{
		image = "cabinet_oat", xCollisionCheckOffset = 59, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0
  		}
 	},
	cabinet_oil =
 	{
  		image = "cabinet_oil", xCollisionCheckOffset = 20, yCollisionCheckOffset = 102, 
		collisionMask =
		{
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
 	},
	cabinet_oyster =
	{
		image = "cabinet_oyster", xCollisionCheckOffset = 60, yCollisionCheckOffset = 60,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0
		}
	},
	cabinet_paste =
	{
		image = "cabinet_paste", xCollisionCheckOffset = 20, yCollisionCheckOffset = 19,
		collisionMask = 
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	cabinet_pineapples =
	{
		image = "cabinet_pineapples", xCollisionCheckOffset = 61, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0,
   		0, 0, 0, 0, 0
  		}
 	},
	cabinet_raisins =
	{
		image = "cabinet_raisins", xCollisionCheckOffset = 59, yCollisionCheckOffset = 60,
  		collisionMask =
  		{
   		0, 0, 0, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 1, 1, 0, 0,
   		0, 0, 0, 0, 0,
   		0, 0, 0, 0, 0
  		}
 	},
	cabinet_soda =
	{
		image = "cabinet_soda", xCollisionCheckOffset = 19, yCollisionCheckOffset = 19,
		collisionMask = 
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	cabinet_spaghetti =
	{
		image = "cabinet_spaghetti", xCollisionCheckOffset = 19, yCollisionCheckOffset = 101,
		collisionMask =
		{
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	cabinet_spice =
	{
		image = "cabinet_spice", xCollisionCheckOffset = 17, yCollisionCheckOffset = 18,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0
		}
	},
	cabinet_sugar =
	{
		image = "cabinet_sugar", xCollisionCheckOffset = 63, yCollisionCheckOffset = 60,
		collisionMask =
		{
			0, 0, 0, 0, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0,
			0, 1, 1, 1, 0
		}
	},
	cabinet_vanilla =
	{
		image = "cabinet_vanilla", xCollisionCheckOffset = 20, yCollisionCheckOffset = 19,
		collisionMask = 
		{
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 1, 0, 0,
			0, 0, 0, 0, 0
		}
	},
}

-- package items
local items = 
{
	-- fridge = 
	{
		items = 
		{
			{ index = 1, target = false, item = "fridge_oj",		depth = foregroundDepth, x = 1, y = 2 },
			{ index = 2, target = false, item = "fridge_wine",		depth = foregroundDepth, x = 3, y = 1 },
			{ index = 3, target = false, item = "fridge_oj",		depth = foregroundDepth, x = 4, y = 2 },
			{ index = 4, target = false, item = "fridge_wine",		depth = foregroundDepth, x = 6, y = 1 },
			{ index = 5, target = false, item = "fridge_peanutbutter",	depth = foregroundDepth, x = 7, y = 2 },
			{ index = 6, target = false, item = "fridge_butter",		depth = foregroundDepth, x = 1, y = 7 },
			{ index = 7, target = false, item = "fridge_yogurt",		depth = foregroundDepth, x = 1, y = 6 },
			{ index = 8, target = false, item = "fridge_yogurt",		depth = foregroundDepth, x = 2, y = 6 },
			{ index = 9, target = false, item = "fridge_peanutbutter",	depth = foregroundDepth, x = 4, y = 5 },
			{ index = 10, target = false, item = "fridge_water",		depth = foregroundDepth, x = 6, y = 6 },
			{ index = 11, target = false, item = "fridge_mayo",		depth = foregroundDepth, x = 7, y = 6 },
			{ index = 12, target = false, item = "fridge_butter",		depth = foregroundDepth, x = 6, y = 5 },
			{ index = 13, target = false, item = "fridge_yogurt",		depth = foregroundDepth, x = 2, y = 8 },
			{ index = 14, target = false, item = "fridge_yogurt",		depth = foregroundDepth, x = 2, y = 9 },
			{ index = 15, target = false, item = "fridge_yogurt",		depth = foregroundDepth, x = 3, y = 9 },
			{ index = 16, target = false, item = "fridge_yogurt",		depth = foregroundDepth, x = 4, y = 9 },
			{ index = 17, target = false, item = "fridge_soda",		depth = foregroundDepth, x = 1, y = 9 },
			{ index = 18, target = false, item = "fridge_mayo",		depth = foregroundDepth, x = 2, y = 10 },
			{ index = 19, target = false, item = "fridge_water",		depth = foregroundDepth, x = 4, y = 10 },
			{ index = 20, target = false, item = "fridge_soda",		depth = foregroundDepth, x = 5, y = 9 },
			{ index = 21, target = false, item = "fridge_spaghetti",	depth = foregroundDepth, x = 7, y = 9 },
			
			{ index = 22, target = true, item = "fridge_milk",		depth = backgroundDepth, x = 5, y = 1 },
		};
		shelves = 
		{
			{ number = 4, shelf_image = "divider_refrigerator", bg_image = "refrigerator_shelf_4_b", bg_image_offset = { x = 25, y = 8 } },
			{ number = 7, shelf_image = "divider_refrigerator", bg_image = "refrigerator_shelf_3_a", bg_image_offset = { x = 45, y = 8 } },
			{ number = 11, shelf_image = "", bg_image = "refrigerator_shelf_4_b", bg_image_offset = { x = 20, y = 8 } },
		};
		shelf_offset = { x = -23, y = -10 };
		background = "closeup_refrigerator";
		gridSquare = gridSquareFridge;
	};	
	-- freezer = 
	{
	items = 
		{
			{ index = 1, target = false, item = "freezer_icetray",		depth = foregroundDepth, x = 2, y = 3 },
			{ index = 2, target = false, item = "freezer_juice",		depth = foregroundDepth, x = 2, y = 1 },
			{ index = 3, target = false, item = "freezer_whipcream",	depth = foregroundDepth, x = 3, y = 1 },
			{ index = 4, target = false, item = "freezer_dinner",		depth = foregroundDepth, x = 5, y = 1 },
			{ index = 5, target = false, item = "freezer_dinner",		depth = foregroundDepth, x = 6, y = 1 },
			{ index = 6, target = false, item = "freezer_coffee",		depth = foregroundDepth, x = 7, y = 1 },
			{ index = 7, target = false, item = "freezer_icecream",		depth = foregroundDepth, x = 1, y = 4 },
			{ index = 8, target = false, item = "freezer_lemonade",		depth = foregroundDepth, x = 4, y = 5 },
			{ index = 9, target = false, item = "freezer_icetray",		depth = foregroundDepth, x = 1, y = 7 },
			{ index = 10, target = false, item = "freezer_juice",		depth = foregroundDepth, x = 4, y = 6 },
			{ index = 11, target = false, item = "freezer_lemonade",	depth = foregroundDepth, x = 6, y = 7 },
			{ index = 12, target = false, item = "freezer_juice",		depth = foregroundDepth, x = 8, y = 6 },
			{ index = 13, target = false, item = "freezer_bread",		depth = foregroundDepth, x = 1, y = 8 },
			{ index = 14, target = false, item = "freezer_pizza",		depth = foregroundDepth, x = 3, y = 8 },
			{ index = 15, target = false, item = "freezer_coffee",		depth = foregroundDepth, x = 4, y = 9 },
			{ index = 16, target = false, item = "freezer_lemonade",	depth = foregroundDepth, x = 4, y = 8 },
			{ index = 17, target = false, item = "freezer_icecream",	depth = foregroundDepth, x = 6, y = 10 },
			{ index = 18, target = false, item = "freezer_whipcream",	depth = foregroundDepth, x = 7, y = 8 },
			
			{ index = 19, target = true, item = "freezer_berries",		depth = backgroundDepth, x = 2, y = 9 },
		};

		shelves = 
		{
			{ number = 3, shelf_image = "divider_refrigerator", bg_image = "refrigerator_shelf_3_a", bg_image_offset = { x = 40, y = 8 } },
			{ number = 5, shelf_image = "divider_refrigerator", bg_image = "refrigerator_shelf_3_b", bg_image_offset = { x = 40, y = 8 } },
			{ number = 7, shelf_image = "divider_refrigerator", bg_image = "refrigerator_shelf_2", bg_image_offset = { x = 20, y = 8 } },
			{ number = 11, shelf_image = "divider_refrigerator", bg_image = "refrigerator_shelf_4_b", bg_image_offset = { x = 20, y = 8 } },
		};
		shelf_offset = { x = -23, y = -6 };
		background = "closeup_refrigerator";
		gridSquare = gridSquareFridge;
	};
	-- cabinet 1 = 
	{
	items = 
		{
			{ index = 1, target = false, item = "cabinet_oil",		depth = foregroundDepth, x = 1, y = 1 },
			{ index = 2, target = false, item = "cabinet_pineapples",	depth = foregroundDepth, x = 2, y = 1 },
			{ index = 3, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 2, y = 3 },
			{ index = 4, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 3, y = 3 },
			{ index = 5, target = false, item = "cabinet_vanilla",		depth = foregroundDepth, x = 4, y = 2 },
			{ index = 6, target = false, item = "cabinet_soda",		depth = foregroundDepth, x = 5, y = 2 },
			{ index = 7, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 6, y = 3 },
			{ index = 8, target = false, item = "cabinet_oat",		depth = foregroundDepth, x = 7, y = 1 },
			{ index = 9, target = false, item = "cabinet_vanilla",		depth = foregroundDepth, x = 1, y = 4 },
			{ index = 10, target = false, item = "cabinet_pineapples",	depth = foregroundDepth, x = 3, y = 4 },
			{ index = 11, target = false, item = "cabinet_chips",		depth = foregroundDepth, x = 6, y = 4 },
			{ index = 12, target = false, item = "cabinet_chips",		depth = foregroundDepth, x = 2, y = 6 },
			--{ index = 13, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 5, y = 7 },
			{ index = 14, target = false, item = "cabinet_raisins",		depth = foregroundDepth, x = 6, y = 6 },
			{ index = 15, target = false, item = "cabinet_paste",		depth = foregroundDepth, x = 8, y = 6 },
			{ index = 16, target = false, item = "cabinet_oat",		depth = foregroundDepth, x = 1, y = 9 },
			{ index = 17, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 3, y = 8 },
			{ index = 18, target = false, item = "cabinet_cakemix",		depth = foregroundDepth, x = 5, y = 9 },
			{ index = 19, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 7, y = 8 },
			{ index = 20, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 8, y = 8 },
			
			{ index = 21, target = true, item = "cabinet_flour",	depth = backgroundDepth, x = 1, y = 8 },
		};
		shelves = 
		{
			{ number = 3, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 5, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 7, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 11, shelf_image = "", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
		};
		shelf_offset = { x = -28, y = -6 };
		background = "Closeup_Cabinet";
	};
	-- cabinet 2 = 
	{
	items = 
		{
			{ index = 1, target = false, item = "cabinet_vanilla",		depth = foregroundDepth, x = 1, y = 1 },
			{ index = 2, target = false, item = "cabinet_vanilla",		depth = foregroundDepth, x = 2, y = 1 },
			{ index = 3, target = false, item = "cabinet_cocoa",		depth = foregroundDepth, x = 1, y = 3 },
			{ index = 4, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 3, y = 1 },
			{ index = 5, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 4, y = 1 },
			{ index = 6, target = false, item = "cabinet_raisins",		depth = foregroundDepth, x = 5, y = 1 },
			{ index = 7, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 7, y = 2 },
			{ index = 8, target = false, item = "cabinet_chips",		depth = foregroundDepth, x = 5, y = 3 },			
			{ index = 9, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 8, y = 1 },
			{ index = 10, target = false, item = "cabinet_cakemix",		depth = foregroundDepth, x = 1, y = 5 },
			{ index = 11, target = false, item = "cabinet_soda",		depth = foregroundDepth, x = 3, y = 6 },
			{ index = 12, target = false, item = "cabinet_oat",		depth = foregroundDepth, x = 4, y = 5 },
			{ index = 13, target = false, item = "cabinet_raisins",		depth = foregroundDepth, x = 6, y = 6 },
			{ index = 14, target = false, item = "cabinet_paste",		depth = foregroundDepth, x = 8, y = 6 },
			{ index = 15, target = false, item = "cabinet_oil",		depth = foregroundDepth, x = 1, y = 9 },
			{ index = 16, target = false, item = "cabinet_cereal",		depth = foregroundDepth, x = 2, y = 8 },
			{ index = 17, target = false, item = "cabinet_cereal",		depth = foregroundDepth, x = 3, y = 8 },
			{ index = 18, target = false, item = "cabinet_oil",		depth = foregroundDepth, x = 4, y = 9 },
			{ index = 19, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 5, y = 8 },
			{ index = 20, target = false, item = "cabinet_paste",		depth = foregroundDepth, x = 6, y = 8 },
			{ index = 21, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 7, y = 8 },
			{ index = 22, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 7, y = 9 },
			{ index = 23, target = false, item = "cabinet_pineapples",	depth = foregroundDepth, x = 6, y = 10 },
			{ index = 24, target = false, item = "cabinet_soda",		depth = foregroundDepth, x = 8, y = 10 },
			
			{ index = 25, target = true, item = "cabinet_applesauce",	depth = backgroundDepth, x = 3, y = 2 },
		};
		shelves = 
		{
			{ number = 4, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 7, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 11, shelf_image = "", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
		};
		shelf_offset = { x = -28, y = -6 };
		background = "Closeup_Cabinet";
	};
	-- cabinet 3 = 
	{
	items = 
		{
			{ index = 1, target = false, item = "cabinet_pineapples",	depth = foregroundDepth, x = 1, y = 1 },
			{ index = 2, target = false, item = "cabinet_chips",		depth = foregroundDepth, x = 3, y = 1 },
			{ index = 3, target = false, item = "cabinet_soda",		depth = foregroundDepth, x = 7, y = 1 },
			{ index = 4, target = false, item = "cabinet_oil",		depth = foregroundDepth, x = 1, y = 4 },
			{ index = 5, target = false, item = "cabinet_oat",		depth = foregroundDepth, x = 2, y = 4 },
			{ index = 6, target = false, item = "cabinet_chips",		depth = foregroundDepth, x = 1, y = 7 },
			{ index = 7, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 4, y = 5 },
			{ index = 8, target = false, item = "cabinet_cakemix",		depth = foregroundDepth, x = 5, y = 4 },			
			{ index = 9, target = false, item = "cabinet_raisins",		depth = foregroundDepth, x = 5, y = 7 },
			{ index = 10, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 7, y = 5 },
			{ index = 11, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 8, y = 4 },
			{ index = 12, target = false, item = "cabinet_cereal",		depth = foregroundDepth, x = 8, y = 5 },
			{ index = 13, target = false, item = "cabinet_oil",		depth = foregroundDepth, x = 1, y = 9 },
			{ index = 14, target = false, item = "cabinet_cocoa",		depth = foregroundDepth, x = 2, y = 10 },
			{ index = 15, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 4, y = 11 },
			{ index = 16, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 4, y = 10 },
			{ index = 17, target = false, item = "cabinet_paste",		depth = foregroundDepth, x = 6, y = 10 },
			{ index = 18, target = false, item = "cabinet_cakemix",		depth = foregroundDepth, x = 7, y = 9 },

			
			{ index = 19, target = true, item = "cabinet_kraut",		depth = backgroundDepth, x = 5, y = 5 },
		};
		shelves = 
		{
			{ number = 2, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 8, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 11, shelf_image = "", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
		};
		shelf_offset = { x = -28, y = -6 };
		background = "Closeup_Cabinet";
	};
	-- cabinet 4 = 
{
	items = 
		{
			{ index = 1, target = false, item = "fridge_peanutbutter",	depth = foregroundDepth, x = 1, y = 1 },
			{ index = 2, target = false, item = "cabinet_soda",		depth = foregroundDepth, x = 3, y = 2 },
			{ index = 3, target = false, item = "cabinet_vanilla",		depth = foregroundDepth, x = 4, y = 2 },
			{ index = 4, target = false, item = "cabinet_paste",		depth = foregroundDepth, x = 5, y = 2 },
			{ index = 5, target = false, item = "cabinet_soda",		depth = foregroundDepth, x = 6, y = 2 },
			{ index = 6, target = false, item = "cabinet_pineapples",	depth = foregroundDepth, x = 7, y = 2 },
			{ index = 7, target = false, item = "cabinet_cocoa",		depth = foregroundDepth, x = 1, y = 4 },
			{ index = 8, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 3, y = 4 },			
			{ index = 9, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 3, y = 5 },
			{ index = 10, target = false, item = "cabinet_pineapples",	depth = foregroundDepth, x = 4, y = 4 },
			{ index = 11, target = false, item = "cabinet_chips",		depth = foregroundDepth, x = 6, y = 4 },
			{ index = 12, target = false, item = "cabinet_vanilla",		depth = foregroundDepth, x = 1, y = 6 },
			{ index = 13, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 2, y = 7 },
			{ index = 14, target = false, item = "cabinet_chips",		depth = foregroundDepth, x = 3, y = 6 },
			{ index = 15, target = false, item = "cabinet_raisins",		depth = foregroundDepth, x = 6, y = 6 },
			{ index = 16, target = false, item = "cabinet_paste",		depth = foregroundDepth, x = 8, y = 6 },
			{ index = 17, target = false, item = "fridge_wine",		depth = foregroundDepth, x = 1, y = 8 },
			{ index = 18, target = false, item = "cabinet_oil",		depth = foregroundDepth, x = 2, y = 9 },
			{ index = 19, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 2, y = 8 },
			{ index = 20, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 3, y = 8 },
			{ index = 21, target = false, item = "cabinet_oil",		depth = foregroundDepth, x = 4, y = 9 },
			{ index = 22, target = false, item = "cabinet_oat",		depth = foregroundDepth, x = 5, y = 9 },
			{ index = 23, target = false, item = "cabinet_cakemix",		depth = foregroundDepth, x = 7, y = 9 },
			{ index = 24, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 7, y = 8 },
			{ index = 25, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 8, y = 8 },
			
			{ index = 26, target = true, item = "cabinet_bakingsoda",	depth = backgroundDepth, x = 6, y = 10 },
		};
		shelves = 
		{
			{ number = 3, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 5, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 7, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 11, shelf_image = "", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
		};
		shelf_offset = { x = -28, y = -6 };
		background = "Closeup_Cabinet";
	};

	-- cabinet 5 = 
{
	items = 
		{
			{ index = 1, target = false, item = "cabinet_oil",		depth = foregroundDepth, x = 1, y = 1 },
			{ index = 2, target = false, item = "cabinet_paste",		depth = foregroundDepth, x = 2, y = 2 },
			{ index = 3, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 3, y = 3 },
			{ index = 4, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 3, y = 2 },
			{ index = 5, target = false, item = "cabinet_dinner",		depth = foregroundDepth, x = 4, y = 1 },
			{ index = 6, target = false, item = "cabinet_vanilla",		depth = foregroundDepth, x = 4, y = 2 },
			{ index = 7, target = false, item = "cabinet_soda",		depth = foregroundDepth, x = 5, y = 2 },
			{ index = 8, target = false, item = "cabinet_paste",		depth = foregroundDepth, x = 6, y = 2 },
			{ index = 9, target = false, item = "cabinet_oat",		depth = foregroundDepth, x = 7, y = 1 },
			{ index = 10, target = false, item = "cabinet_cocoa",		depth = foregroundDepth, x = 1, y = 4 },
			{ index = 11, target = false, item = "cabinet_pineapples",	depth = foregroundDepth, x = 3, y = 4 },
			{ index = 12, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 5, y = 4 },
			{ index = 13, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 5, y = 5 },
			{ index = 14, target = false, item = "cabinet_dinner",		depth = foregroundDepth, x = 6, y = 5 },
			{ index = 15, target = false, item = "cabinet_pineapples",	depth = foregroundDepth, x = 1, y = 7 },
			{ index = 16, target = false, item = "fridge_peanutbutter",	depth = foregroundDepth, x = 1, y = 9 },
			{ index = 17, target = false, item = "fridge_wine",		depth = foregroundDepth, x = 4, y = 8 },
			{ index = 18, target = false, item = "cabinet_oil",		depth = foregroundDepth, x = 3, y = 9 },
			{ index = 19, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 5, y = 8 },
			{ index = 20, target = false, item = "cabinet_raisins",		depth = foregroundDepth, x = 6, y = 7 },
			{ index = 21, target = false, item = "cabinet_cakemix",		depth = foregroundDepth, x = 6, y = 9 },
			{ index = 22, target = false, item = "cabinet_cereal",		depth = foregroundDepth, x = 8, y = 8 },

			{ index = 23, target = true, item = "cabinet_oyster",		depth = backgroundDepth, x = 3, y = 8 },
		};
		shelves = 
		{
			{ number = 3, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 5, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 11, shelf_image = "", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
		};
		shelf_offset = { x = -28, y = -6 };
		background = "Closeup_Cabinet";
	};
	-- cabinet 6 = 
	{
	items = 
		{
			{ index = 1, target = false, item = "cabinet_oat",		depth = foregroundDepth, x = 1, y = 1 },
			{ index = 2, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 3, y = 2 },
			{ index = 3, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 3, y = 3 },
			{ index = 4, target = false, item = "cabinet_raisins",		depth = foregroundDepth, x = 4, y = 2 },
			{ index = 5, target = false, item = "cabinet_chips",		depth = foregroundDepth, x = 6, y = 2 },
			{ index = 6, target = false, item = "cabinet_cocoa",		depth = foregroundDepth, x = 1, y = 4 },
			{ index = 7, target = false, item = "cabinet_chips",		depth = foregroundDepth, x = 1, y = 6 },
			{ index = 8, target = false, item = "cabinet_raisins",		depth = foregroundDepth, x = 4, y = 6 },			
			{ index = 9, target = false, item = "cabinet_vanilla",		depth = foregroundDepth, x = 5, y = 4 },
			{ index = 10, target = false, item = "cabinet_cakemix",		depth = foregroundDepth, x = 6, y = 5 },
			{ index = 11, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 8, y = 4 },
			{ index = 12, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 8, y = 5 },
			{ index = 13, target = false, item = "cabinet_paste",		depth = foregroundDepth, x = 8, y = 6 },
			{ index = 14, target = false, item = "cabinet_pineapples",	depth = foregroundDepth, x = 1, y = 8 },
			{ index = 15, target = false, item = "cabinet_pineapples",	depth = foregroundDepth, x = 1, y = 10 },
			{ index = 16, target = false, item = "cabinet_cereal",		depth = foregroundDepth, x = 3, y = 8 },
			{ index = 17, target = false, item = "cabinet_cereal",		depth = foregroundDepth, x = 4, y = 8 },
			{ index = 18, target = false, item = "cabinet_spice",		depth = foregroundDepth, x = 5, y = 9 },
			{ index = 19, target = false, item = "cabinet_paste",		depth = foregroundDepth, x = 5, y = 10 },
			{ index = 20, target = false, item = "cabinet_spaghetti",	depth = foregroundDepth, x = 6, y = 8 },
			{ index = 21, target = false, item = "cabinet_soda",		depth = foregroundDepth, x = 7, y = 10 },
			{ index = 22, target = false, item = "cabinet_oil",		depth = foregroundDepth, x = 8, y = 9 },
			
			{ index = 23, target = true, item = "cabinet_sugar",	depth = backgroundDepth, x = 3, y = 4 },
		};
		shelves = 
		{
			{ number = 3, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 7, shelf_image = "divider_cabinet", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
			{ number = 11, shelf_image = "", bg_image = "", bg_image_offset = { x = 20, y = 8 } },
		};
		shelf_offset = { x = -28, y = -6 };
		background = "Closeup_Cabinet";
	};

};

function get_package_item_spec(_name, _image, _depth, _x, _y, _info)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:SetDepthValue(_depth);
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor_open_hand");
			actor.moving = false;
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor:SayRaw("");
			actor.info = _info;
			if ( actor.info.target == true ) then
				actor:SetDepthValue( targetDepth );
			end
			actor.collisionUsed = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
			actor.placed = false;
			actor.snapToPos = { x = 0, y = 0 };
			actor.snapBackPos = { x = _x, y = _y };
			
			actor.on_click = function(flo, package_item)
				if ( actor.info.target == true ) then
					if CanGetOut( actor ) then					
						--actor:SetAlpha(0);
						target_item = actor;
						actor:DumpZone(); -- make sure we can't click again
						flo:StartProc(activity_passed);
						return
					else
						help_panel_say_raw(scene:grabstring("help_item_blocked"));
						scene.HELP_PANEL_HELPER:StartProc(resume_help_on_click);
					end
				end
				if ( _depth ~= foregroundDepth ) then
					return;
				end
				if actor.moving == false and moving_actor == nil then
					if IsUnderSomething( actor ) then
						help_panel_say_raw(scene:grabstring("help_item_under"));
						scene.HELP_PANEL_HELPER:StartProc(resume_help_on_click);
						return;
					end
					local clickedAt = scene:GetClickedAtScreen();
					actorPos = actor:GetPosition();
					actor.snapBackPos = actorPos;
					actor.moving = true;
					actor.movingx = actorPos.x - clickedAt.x;
					actor.movingy = actorPos.y - clickedAt.y ;
					actor:SetDepthValue(currentDepth);
					currentDepth = currentDepth + 1;
					sfx:PlaySFX( "audio/sfx/cake_pickup.ogg", false );
					actor:SetPointAtCursor("cursor_closed_hand");
					actor:StartProc(move_item);
				else
					local cursorPos = scene:GetCursorPos();
					if ( CanBePlacedHere(actor) ) then
						sfx:PlaySFX( "audio/sfx/cake_drop", false );
						PlaceObject(actor);
						actor:SetAlpha(1);
						actor.moving = false;
						actor:SetPointAtCursor("cursor_open_hand");
					elseif ( PointInRectangle( { x = cursorPos.x, y = cursorPos.y }, { tlx = floorFormatInfo["screen_x_offset"], tly = floorFormatInfo["screen_y_offset"], brx = floorFormatInfo["screen_x_offset"] + floorFormatInfo["floor_width"], bry = floorFormatInfo["screen_y_offset"] + floorFormatInfo["floor_height"] } ) )  then
					-- if clicking on floor
						actor:JumpToPoint { x = actor.snapBackPos.x, y = actor.snapBackPos.y };	
						actor:SetAlpha(1);
						sfx:PlaySFX( "audio/sfx/cake_drop", false );
						actor.moving = false;
						actor:SetPointAtCursor("cursor_open_hand");
						skipChecks = true;
						UpdateGridHighlighting(actor);
						if ( CanBePlacedHere(actor) ) then
							PlaceObject(actor);
						end
						skipChecks = false;
					else -- otherwise do nothing other than play the sound effect
						actor:JumpToPoint { x = actor.snapBackPos.x, y = actor.snapBackPos.y };	
						actor:SetAlpha(1);
						sfx:PlaySFX( "audio/sfx/cake_drop", false );
						actor.moving = false;
						actor:SetPointAtCursor("cursor_open_hand");
						skipChecks = true;
						UpdateGridHighlighting(actor);
						if ( CanBePlacedHere(actor) ) then
							PlaceObject(actor);
						end
						skipChecks = false;
					end 
				end
				return RESPONSE.IGNORE;
			end;
		end;
	}
end

function CanGetOut( actor )
	local position = actor:GetPosition();
	local xPos = position.x + fridge_items[actor.info.item].xCollisionCheckOffset;
	local yPos = position.y + fridge_items[actor.info.item].yCollisionCheckOffset;
	-- Find corresponding position on the grid
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	local gridSquareCentreIndexX = 0;
	local gridSquareCentreIndexY = 0;
	for i = 1, numGridSquares do
		local squarePosition = grid[i]:GetPosition();
		local squareXPos = squarePosition.x;
		local squareYPos = squarePosition.y;
		if ( PointInRectangle( { x = xPos, y = yPos }, { tlx = squareXPos, tly = squareYPos, brx = squareXPos + gridSquare.width, bry = squareYPos + gridSquare.height } ) ) then
			gridSquareCentreIndexX = grid[i].xIndex;
			gridSquareCentreIndexY = grid[i].yIndex;
			actor["snapToPos"].x = squareXPos + ( gridSquare.width / 2 ) - fridge_items[actor.info.item].xCollisionCheckOffset;
			actor["snapToPos"].y = squareYPos + ( gridSquare.height / 2 ) - fridge_items[actor.info.item].yCollisionCheckOffset;
			break;
		end
	end
	-- For each square in collision mask, check offset against grid	
	for i = 1, collisionInfo.maxCollisionWidth do	
		local relativeXPosition = i - ( math.floor( collisionInfo.maxCollisionWidth / 2 ) + 1 );
		for j = 1, collisionInfo.maxCollisionHeight do
			local hasCollision = HasCollisionAt( actor, i, j );
			local relativeYPosition = j - ( math.floor( collisionInfo.maxCollisionHeight / 2 ) + 1 );
			local gridSquareX = gridSquareCentreIndexX + relativeXPosition;
			local gridSquareY = gridSquareCentreIndexY + relativeYPosition;
			local pointInRectangle = PointInRectangle( { x = gridSquareX, y = gridSquareY }, { tlx = 1, tly = 1, brx = gridFormatInfo["grid_width"], bry = gridFormatInfo["grid_height"] } );
			local index = ( (gridSquareY - 1) * gridFormatInfo["grid_width"] ) + gridSquareX;				
			local collisionIndex = ( (j - 1) * collisionInfo.maxCollisionWidth ) + i;	
			if ( pointInRectangle and hasCollision ) then
				local squareIsUnoccupied = ( grid[index].occupied == "" );
				if ( squareIsUnoccupied == false ) then
					return false;
				end
			end
		end
	end		
	return true;
end

function IsUnderSomething( actor )
	local position = actor:GetPosition();	
	local xPos = position.x + fridge_items[actor.info.item].xCollisionCheckOffset;
	local yPos = position.y + fridge_items[actor.info.item].yCollisionCheckOffset;
	-- Find corresponding position on the grid
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	local gridSquareCentreIndexX = 0;
	local gridSquareCentreIndexY = 0;
	for i = 1, numGridSquares do
		local squarePosition = grid[i]:GetPosition();
		local squareXPos = squarePosition.x;
		local squareYPos = squarePosition.y;
		if ( PointInRectangle( { x = xPos, y = yPos }, { tlx = squareXPos, tly = squareYPos, brx = squareXPos + gridSquare.width, bry = squareYPos + gridSquare.height } ) ) then
			gridSquareCentreIndexX = grid[i].xIndex;
			gridSquareCentreIndexY = grid[i].yIndex;
			actor["snapToPos"].x = squareXPos + ( gridSquare.width / 2 ) - fridge_items[actor.info.item].xCollisionCheckOffset;
			actor["snapToPos"].y = squareYPos + ( gridSquare.height / 2 ) - fridge_items[actor.info.item].yCollisionCheckOffset;
			break;
		end
	end
	if ( gridSquareCentreIndexX == 0 or gridSquareCentreIndexY == 0 ) then
		return true;
	end

	-- For each square in collision mask, check offset against grid	
	for i = 1, collisionInfo.maxCollisionWidth do	
		local relativeXPosition = i - ( math.floor( collisionInfo.maxCollisionWidth / 2 ) + 1 );
		for j = 1, collisionInfo.maxCollisionHeight do
			local hasCollision = HasCollisionAt( actor, i, j );
			local relativeYPosition = j - ( math.floor( collisionInfo.maxCollisionHeight / 2 ) + 1 );
			local gridSquareX = gridSquareCentreIndexX + relativeXPosition;
			local gridSquareY = gridSquareCentreIndexY + relativeYPosition;
			local index = ( (gridSquareY - 1) * gridFormatInfo["grid_width"] ) + gridSquareX;				
			local collisionIndex = ( (j - 1) * collisionInfo.maxCollisionWidth ) + i;	
			
			local collisionIndex = collisionIndex - collisionInfo.maxCollisionWidth;			
			-- if top of object
			if ( hasCollision and ( collisionIndex <= 0 or fridge_items[actor.info.item].collisionMask[collisionIndex] ~= 1 ) ) then
				local gridIndex = index - gridFormatInfo["grid_width"];
				-- is not at top of grid
				if ( gridIndex > 0 ) then
					-- check shelves
					local topOfShelf = false;
					for i = 1, numShelves do
						if ( shelves[i].index == gridSquareY - 1 ) then
							topOfShelf = true;
						end
					end
					if ( topOfShelf == false ) then
						-- check objects
						if ( grid[gridIndex].occupied ~= "" ) then
							return true;
						end
					end
				end					
			end
		end
	end	
	-- not under anything
	return false;
end

function move_item(actor)	
	--GridSetAlpha(1);
	moving_actor = actor;
	while actor.moving do
		actor.collisionUsed = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
		if ( actor.placed ) then
			UnplaceObject(actor);
		end
		local cursorPos = scene:GetCursorPos();
		actor:JumpToPoint { x = cursorPos.x + actor.movingx, y = cursorPos.y + actor.movingy };	
		UpdateGridHighlighting(actor);
		if ( CanBePlacedHere(actor) ) then
			Highlight(actor);
			actor:SetAlpha(1);
		else
			UnhighlightGrid();
			actor:SetAlpha(0.5);
		end
		delay(1);
	end
	actor:SetTint( { a = 1, r = 1, g = 1, b = 1 } );
	--GridSetAlpha(0);
	moving_actor = nil;
end

function UnplaceObject(actor)
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	for i = 1, numGridSquares do
		if ( grid[i].occupied == actor["info"].index ) then
			grid[i].highlighted = grid[i].occupied;
			grid[i].occupied = "";
			grid[i]:LoadImage(gridSquare.highlight);
		end
	end
	actor.placed = false;
end

function PlaceObject(actor)
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];	
	for i = 1, numGridSquares do
		if ( grid[i].highlighted == actor["info"].index ) then
			grid[i].occupied = grid[i].highlighted;
			grid[i].highlighted = "";	
			grid[i]:LoadImage(gridSquare.occupied);
		end
	end
	actor.placed = true;
	actor:JumpToPoint { x = actor["snapToPos"].x, y = actor["snapToPos"].y };
end

function WholeGridOccupied()
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	for i = 1, numGridSquares do
		if ( grid[i].occupied == "" ) then
			return false;
		end		
	end
	return true;
end

function CanBePlacedHere( actor )
	local numCollisionBits = collisionInfo.maxCollisionWidth * collisionInfo.maxCollisionHeight;
	for i = 1, numCollisionBits do
		if ( ( fridge_items[actor.info.item].collisionMask[i] == 1 ) and ( actor.collisionUsed[i] ~= 1 ) ) then			
			return false;
		end
	end
	-- all collision is being used, i.e. they entire object is on an unoccupied part of the grid
	return true
end

function Highlight( actor )
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];	
	for i = 1, numGridSquares do
		if ( grid[i].highlighted == actor["info"].index ) then
			grid[i]:LoadImage(gridSquare.highlight);
		end
	end	
end

function GridSetAlpha( alpha )
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];	
	for i = 1, numGridSquares do
		grid[i]:SetAlpha( alpha );
	end	
end

function UnhighlightGrid()
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	for i = 1, numGridSquares do
		if ( grid[i].occupied == "" ) then 
			grid[i].highlighted = "";
			grid[i]:LoadImage(gridSquare.image);
		end
	end
end

function UpdateGridHighlighting(actor)
	local position = actor:GetPosition();
	local xPos = position.x + fridge_items[actor.info.item].xCollisionCheckOffset;
	local yPos = position.y + fridge_items[actor.info.item].yCollisionCheckOffset;
	-- Find corresponding position on the grid
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	local gridSquareCentreIndexX = 0;
	local gridSquareCentreIndexY = 0;
	for i = 1, numGridSquares do
		local squarePosition = grid[i]:GetPosition();
		local squareXPos = squarePosition.x;
		local squareYPos = squarePosition.y;
		if ( PointInRectangle( { x = xPos, y = yPos }, { tlx = squareXPos, tly = squareYPos, brx = squareXPos + gridSquare.width, bry = squareYPos + gridSquare.height } ) ) then
			gridSquareCentreIndexX = grid[i].xIndex;
			gridSquareCentreIndexY = grid[i].yIndex;
			actor["snapToPos"].x = squareXPos + ( gridSquare.width / 2 ) - fridge_items[actor.info.item].xCollisionCheckOffset;
			actor["snapToPos"].y = squareYPos + ( gridSquare.height / 2 ) - fridge_items[actor.info.item].yCollisionCheckOffset;
			break;
		end
	end
	UnhighlightGrid();
	if ( gridSquareCentreIndexX == 0 or gridSquareCentreIndexY == 0 ) then
		return;
	end
	-- For each square in collision mask, check offset against grid	
	for i = 1, collisionInfo.maxCollisionWidth do	
		local relativeXPosition = i - ( math.floor( collisionInfo.maxCollisionWidth / 2 ) + 1 );
		for j = 1, collisionInfo.maxCollisionHeight do
			local hasCollision = HasCollisionAt( actor, i, j );
			local relativeYPosition = j - ( math.floor( collisionInfo.maxCollisionHeight / 2 ) + 1 );
			local gridSquareX = gridSquareCentreIndexX + relativeXPosition;
			local gridSquareY = gridSquareCentreIndexY + relativeYPosition;
			local pointInRectangle = PointInRectangle( { x = gridSquareX, y = gridSquareY }, { tlx = 1, tly = 1, brx = gridFormatInfo["grid_width"], bry = gridFormatInfo["grid_height"] } );
			local index = ( (gridSquareY - 1) * gridFormatInfo["grid_width"] ) + gridSquareX;				
			local collisionIndex = ( (j - 1) * collisionInfo.maxCollisionWidth ) + i;	
			actor.collisionUsed[collisionIndex] = 0;		
			if ( pointInRectangle ) then
				local squareIsUnoccupied = ( grid[index].occupied == "" );
				grid[index].highlighted = "";
				if ( hasCollision and squareIsUnoccupied and ( ShelfInWay( actor, collisionIndex, gridSquareY ) == false ) and  ( IsOnSomething( actor, collisionIndex, index, gridSquareY ) == true ) ) then
					actor.collisionUsed[collisionIndex] = 1;
					grid[index].highlighted = actor["info"].index;
				end
			end
		end
	end	
end

function IsOnSomething( actor, collisionIndex, gridIndex, y )	
	if ( skipChecks ) then
		return true;
	end
	-- not bottom of object
	local collisionIndex = collisionIndex + collisionInfo.maxCollisionWidth;
	if ( collisionIndex <= ( collisionInfo.maxCollisionWidth * collisionInfo.maxCollisionHeight ) ) then
		if ( fridge_items[actor.info.item].collisionMask[collisionIndex] == 1 ) then
			return true;
		end
	end	
	-- on shelf
	for i = 1, numShelves do					
		if ( shelves[i].index == y ) then			
			return true;
		end
	end
	-- on object
	local gridIndex = gridIndex + gridFormatInfo["grid_width"];
	if ( grid[gridIndex].occupied ~= "" ) then
		return true;
	end
	-- not on anything
	return false;
end

function ShelfInWay( actor, collisionIndex, y )
	if ( y == gridFormatInfo["grid_height"]  ) then		
		return false;
	end
	local collisionIndex = collisionIndex + collisionInfo.maxCollisionWidth;
	if ( collisionIndex > ( collisionInfo.maxCollisionWidth * collisionInfo.maxCollisionHeight ) ) then
		return false;
	end
	if ( fridge_items[actor.info.item].collisionMask[collisionIndex] ~= 1 ) then
		return false;
	end
	for i = 1, numShelves do				
		if ( shelves[i].index == y ) then
			return true;
		end
	end
	return false;
end

function HasCollisionAt( actor, x, y )
	local index = ( (y - 1) * collisionInfo.maxCollisionWidth ) + x;	
	if ( fridge_items[actor.info.item].collisionMask[index] == 1 ) then
		return true;
	end
	return false;
end

function PointInRectangle( point, rectangle )
	if ( point.x < rectangle.tlx ) then
		return false;
	elseif ( point.x > rectangle.brx ) then
		return false;
	elseif ( point.y < rectangle.tly ) then
		return false;
	elseif ( point.y > rectangle.bry ) then
		return false;
	end
	return true;
end

function reset()
	if ( gridSpawned ) then	
		for i = 1, gridFormatInfo["grid_height"] do
			for j = 1, gridFormatInfo["grid_width"] do
				local index = ( (i - 1) * gridFormatInfo["grid_width"] ) + j;	
				grid[index]:Expire();
			end
		end
	end
	grid = { };
	gridSpawned = false;	
	
	for i = 1, numPackageItems do
		package_items[i]:Expire();
	end
	package_items = { };
	numPackageItems = 0;	

	for i = 1, numShelves do
		shelves[i]:Expire();
	end	
	shelves = { };
	numShelves = 0;
end

function spawn_package_items(actor)
	for i,v in pairs(items) do
		if i == game:Get("fridge_puzzle_index") then
			for j,w in pairs(v.items) do
				local position = { x = gridFormatInfo.screen_x_offset + ( w.x - 1 ) * gridSquare.width, y = gridFormatInfo.screen_y_offset + ( w.y - 1 ) * gridSquare.height };
				local package_item_spec = get_package_item_spec(tostring(j) .. tostring( game:Get("fridge_puzzle_index") ), fridge_items[w.item].image, w.depth, position.x, position.y, w);
				if ( w.depth == foregroundDepth ) then				
					if currentDepth <= w.depth then
						currentDepth = w.depth + 1;
					end		
				end
				local item = scene:Spawn(package_item_spec);
				if ( w.depth == foregroundDepth ) then								
					numPackageItems = numPackageItems + 1;					
					table.insert( package_items, numPackageItems, item );		
					-- snap item into starting position
					UpdateGridHighlighting(item);
					if ( CanBePlacedHere(item) ) then
						PlaceObject(item);
					end
				else					
					if ( w.target == false ) then
						--item:SetAlpha( 0.5 );
						item:SetTint( { a = 1, r = 0.5, g = 0.5, b = 0.5 } );
					end
					PlaceBackgroundItem(item);
				end
			end
			for j,w in pairs(v.shelves) do
				local position = { x = gridFormatInfo.screen_x_offset + v.shelf_offset.x, y = gridFormatInfo.screen_y_offset + w.number * gridSquare.height + v.shelf_offset.y};
				numShelves = numShelves + 1;
				local shelf_spec = get_shelf_item_spec( "shelf" .. tostring(j) .. tostring( game:Get("fridge_puzzle_index") ), w.shelf_image, position, w.number );
				local shelf = scene:Spawn(shelf_spec);
				table.insert( shelves, numShelves, shelf );
				position = { x = gridFormatInfo.screen_x_offset + v.shelf_offset.x + w.bg_image_offset.x, y = gridFormatInfo.screen_y_offset + w.number * gridSquare.height + v.shelf_offset.y + w.bg_image_offset.y};
				spawn_shelf_background(string.upper(w.bg_image) .. "_" .. j, w.bg_image, position);
			end
			
			if v.gridSquare then
				gridSquare = v.gridSquare;
			end
			
			spawn_background(v.background);
		end
	end	
end

function PlaceBackgroundItem(actor)
	local position = actor:GetPosition();
	local xPos = position.x + fridge_items[actor.info.item].xCollisionCheckOffset;
	local yPos = position.y + fridge_items[actor.info.item].yCollisionCheckOffset;
	-- Find corresponding position on the grid
	local numGridSquares = gridFormatInfo["grid_height"] * gridFormatInfo["grid_width"];
	local gridSquareCentreIndexX = 0;
	local gridSquareCentreIndexY = 0;
	for i = 1, numGridSquares do
		local squarePosition = grid[i]:GetPosition();
		local squareXPos = squarePosition.x;
		local squareYPos = squarePosition.y;
		if ( PointInRectangle( { x = xPos, y = yPos }, { tlx = squareXPos, tly = squareYPos, brx = squareXPos + gridSquare.width, bry = squareYPos + gridSquare.height } ) ) then
			gridSquareCentreIndexX = grid[i].xIndex;
			gridSquareCentreIndexY = grid[i].yIndex;
			actor["snapToPos"].x = squareXPos + ( gridSquare.width / 2 ) - fridge_items[actor.info.item].xCollisionCheckOffset;
			actor["snapToPos"].y = squareYPos + ( gridSquare.height / 2 ) - fridge_items[actor.info.item].yCollisionCheckOffset;
			break;
		end
	end		
	actor:JumpToPoint { x = actor["snapToPos"].x, y = actor["snapToPos"].y };
end

function get_shelf_item_spec( _name, _image, _position, _index )
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };		
		
		command = function(actor)
			actor:JumpToPoint(_position);
			actor:SetAlpha( 1 );
			actor.index = _index;
		end;
	}
end

function spawn_grid()
	for i = 1, gridFormatInfo["grid_height"] do
		for j = 1, gridFormatInfo["grid_width"] do
			local xPos = gridFormatInfo["screen_x_offset"] + ( j - 1 ) * gridSquare.width;
			local yPos = gridFormatInfo["screen_y_offset"] + ( i - 1 ) * gridSquare.height;
			local gridSquare_item_spec = get_gridSquare_item_spec( "gridSquare" .. tostring( game:Get("fridge_puzzle_index") ) .. tostring(j) .. tostring(i), gridSquare.image, xPos, yPos, j, i );
			local index = ( (i - 1) * gridFormatInfo["grid_width"] ) + j;	
			table.insert( grid, index, scene:Spawn(gridSquare_item_spec));
		end
	end
	--GridSetAlpha(0);
	gridSpawned = true;	
end

function get_gridSquare_item_spec(_name, _image, _x, _y, _xIndex, _yIndex)
	return
	{
		name = _name;
		halo = _image;
		gfx = { image = _image };
	
		command = function(actor)
			actor:SetDepthValue( gridSquare.depth );
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetPointAtCursor("cursor");
			actor:SetAlpha( gridSquare.alpha );
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 30,
				x = -15,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor.moving = false;
			actor.xIndex = _xIndex;
			actor.yIndex = _yIndex;
			actor.occupied = "";
			actor.highlighted = "";
		end;
	}
end

function spawn_background(_image)
	return
		scene:Spawn
		{
			name = "BACKGROUND";
			gfx = { image = _image };
			
			command = function(actor)
				actor:SetDepthMode(DEPTH.DEPTH_BACKMOST);
			end;
		};
end

function spawn_shelf_background(_name, _image, _position)
	return
		scene:Spawn
		{
			name = _name;
			gfx = { image = _image };
			
			command = function(actor)
				actor:JumpToPoint(_position);
				actor:SetDepthValue(1);
				if actor:HasGraphics() then
					local size = actor:GetImageSize();
					actor:JumpToPoint { x = _position.x, y = _position.y - size.y };
				end
			end;
		};
end

function resume_help_on_click(help_panel)
	coroutine.yield(RESUME.NOW);
	coroutine.yield(RESUME.ON_CLICK);
	coroutine.yield(RESUME.NOW);
	coroutine.yield(RESUME.ON_MOUSE_NOT_DOWN);
	help_panel_say_raw(scene:grabstring("help_" .. tostring(game:Get("fridge_puzzle_index"))));
end

help_panel_helper_spec = 
{
	name = "HELP_PANEL_HELPER";
	
	command = function(actor)
	end;
};

function setup_activity()
	local activityNum = game:Get("fridge_puzzle_index");
	
	help_panel_say_raw(scene:grabstring("help_" .. tostring(activityNum)));
	
	reset();
	spawn_grid();
	skipChecks = true;
	spawn_package_items();
	skipChecks = false;
end;

function next_activity(flo)
	local activityNum = game:Get("fridge_puzzle_index");
	local roundComplete = activityNum == 1; -- on next round
	
	if roundComplete then	
		scene:ReturnFromScene();
	else
		scene.NEXT_ACTIVITY_BUTTON:Expire();
		
		if IsCheatMode() then
			spawn_button(pass_activity_button_spec);
		end
		
		spawn_button(hint_button_spec);		
		spawn_button(back_button_spec);
		
		-- load new puzzle
		setup_activity();
	end
end;

function activity_passed(flo)
	flo:SetMode(MODE.CUTSCENE);
	local activityNum = game:Get("fridge_puzzle_index");
	
	for i = 1, numPackageItems do
		package_items[i]:DumpZone(); -- can't pick up items once activity is passed
	end
	
	if IsCheatMode() then
		scene.PASS_ACTIVITY_BUTTON:Expire();
	end
	
	scene.HINT_BUTTON:Expire();
	scene.BACK_BUTTON:Expire();
	
	game:Set( "Has " ..  recipeInfo.ingredients[game:Get( "fridge_puzzle_index" )], 1 );
	
	spawn_activity_complete_text("activity_complete_text", "audio/sfx/complete_pattern.ogg");
	coroutine.yield(RESUME.ON_SIGNAL);
	
	if target_item then
		target_item:SetAlpha(0);
	end
	sfx:PlaySFX( "audio/sfx/cake_activity_reward", false );
	do_item_flash(flo, game:Get( "fridge_puzzle_index" ));
	delay(60);
	
	-- save progress
	game:SaveGame();
	
	scene:ReturnFromScene();
end;

function do_item_flash(player, item_index)
	local inventory_popup = scene:Spawn
	{
		name = "INVENTORY_POPUP";
		
		command = function(actor)
			actor:SetDepthMode(DEPTH.DEPTH_FRONTMOST)
			actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
		end;
	};
	
	if item_index > 0 then
		local popupScale = 1;
		local moveTime = 25;
		local flashFrequency = 10;
		local flashTime = 50;
		local imageStr = "popup/pop_kitchen_item" .. item_index;
		local imageHaloStr = "popup/pop_kitchen_item" .. item_index .. "_halo";
		
		-- if we have the popup halo image, load the popup image
		inventory_popup:LoadImage(imageHaloStr);
		if inventory_popup:HasGraphics() then
			inventory_popup:LoadImage(imageStr);
		end
		
		-- if we have the popup image, do the fancy effects
		if inventory_popup:HasGraphics() then
			--sfx:PlaySFX("audio/sfx/get_item.ogg");
			inventory_popup:SetScale(popupScale);
			--inventory_popup:AddFlag(AFLAG.AFLAG_NEW_PARTY);
			
			local imageSize = inventory_popup:GetImageSize();
			local popupLocation = { x = 400 - (imageSize.x / 2), y = 250 - (imageSize.y / 2) };
			
			inventory_popup:JumpToPoint(popupLocation)
			--inventory_popup:SetPartyOffset( { x = (imageSize.x / 2), y = (imageSize.y / 2) } );
			--inventory_popup:LoadParty("fx/inventory_party.lua");
		
			local timer = 0;
			local halo = true;
			
			-- flash
			while timer < flashTime do
				if halo then
					inventory_popup:LoadImage(imageStr);
					halo = false;
				else
					inventory_popup:LoadImage(imageHaloStr);
					halo = true;
				end
				
				timer = timer + flashFrequency;
				delay(flashFrequency);
			end
		else
			coroutine.yield(RESUME.NOW);
		end
	end
end;

function fail_activity(flo)
	-- display message of some sort
	setup_activity();
end;

flo_spec =
{
	name = "FLO";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

function pass_activity(flo)
	flo:StartProc(activity_passed);
end

function go_back(flo)
	scene:ReturnFromScene();
end

local hint_button_choice = 0;

hint_button_spec = 
{
	name = "HINT_BUTTON";
	text = "hint";
	halo = "quest/objects/button_thin";
	position = { x = 588, y = 530+hud_lower_offset };
	image = "buttons/button_thin";
	rolloversound = "audio/sfx/button_rollover";
	clicksound = "audio/sfx/buttonclick";
	depth = 50;
	say_spec =
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			y = 11,
			x = 0,
			w = 110,
			h = 20,
			bubble = false,
			lineheight = 17,
			outline_size = 0,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
	
	on_click = function(flo, actor)
		if game:Get( "fridge_puzzle_index" ) ~= 1 then
			help_panel_say_raw(scene:grabstring("hint_" .. tostring(game:Get("fridge_puzzle_index"))));
		else	
			if hint_button_choice == 1 then
				hint_button_choice = 2;
				help_panel_say_raw(scene:grabstring("hint_" .. tostring(game:Get("fridge_puzzle_index"))));
			else
				help_panel_say_raw(scene:grabstring("instructions"));
				hint_button_choice = 1;
			end
		end
		scene.HELP_PANEL_HELPER:StartProc(resume_help_on_click);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/petspamusic.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up(true, true);
		lower_hud();
		spawn_button(hint_button_spec);
		spawn_help_panel(true);
		
		if IsCheatMode() then
			--testing
			spawn_button(pass_activity_button_spec);
		end
		
		-- set up for initial play
		if game:Get("fridge_puzzle_index") < 1 then
			game:Set("fridge_puzzle_index", 1);
		end
		
		setup_activity();
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces1",
		"pieces2",
		"pieces3",
	};
	
	bg_image = 
	{
		--{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		help_panel_helper_spec,
		scene_setup,
	};
};
